function [clustermatrixsave,clusterallocselectind,riskthetasave,clusterallocsave,psicsave,phisave,switchessave,rhosave,alphaforpsisave,betaconfsave]...
    =mainnointwithordinalarand(y,x,wconf,nuoflevels,burnin,iter,thin,maxnumberofclusters,indicateordinal)
% THIS FUNCTION IMPLEMENTS THE PROFILE REGRESSION MODEL IN THE GEN-AIR PAPER  
% Gibbs sampling is employed 
% ALSO TAKES INTO ACCOUNT MISSING X'S

sizey=size(y,1); % the number of subjects 
numberofx=size(x,2); % number of covariates
[missingx,wheremissingx]=checkformissingx(x); %checks for missing x. Returns
      % logical 0/1 and logical 0/1 indicator where the missing values are
        
% *************************************************************
% preallocating memory 
% *************************************************************
indyincluster=cell(1,maxnumberofclusters);
betaphi=cell(1,size(x,2));
ncjx=cell(maxnumberofclusters+1,size(x,2)); % +1 for the phis for when the switch is zero
phi=cell(maxnumberofclusters+1,size(x,2)); % +1 for the phis for when the switch is zero
% tlatent=cell(maxnumberofclusters,max(nuoflevels),numberofx); %FOR GIBBS
gammathres=cell(maxnumberofclusters+1,sum(indicateordinal)); % +1 for the phis for when the switch is zero
betaconf=zeros(size(wconf,2),1);
psicsave=zeros(iter,maxnumberofclusters);
phisave=cell(iter,maxnumberofclusters,size(x,2));
Nosubjectsincluster=zeros(1,maxnumberofclusters);% num of subjects per cluster
Noyonesincluster=zeros(1,maxnumberofclusters); % num of y's =1 in each cluster
clustermatrixsave=zeros(sizey,sizey); 
riskthetasave=zeros(iter,maxnumberofclusters);
clusterallocsave=zeros(iter,sizey);
acc_prob_counter=0; % for the metropolis part for the thresholds
switchessave=zeros(iter,numberofx);
rhosave=zeros(iter,1);
alphaforpsisave=zeros(iter,1); leftbound=0.3; rightbound=10;
betaconfsave=zeros(iter,size(wconf,2));

% *************************************************************
% intitial values for the model parameters
% *************************************************************

switches=zeros(1,numberofx);

fixedprofileequalityvector=zeros(size(y,1),1); %generate vector with equal elements for subjects with equal profiles
indexplusone=0;
for ist=1:size(y,1) % subject loop
    if (fixedprofileequalityvector(ist,1)==0 && sum(x(ist,:)==-999)==0 && sum(wconf(ist,:)==-999)==0)
        fixedprofileequalityvector=fixedprofileequalityvector+ismember([y x wconf],[y(ist,1) x(ist,:) wconf(ist,:)],'rows')*(1+indexplusone);
        %ismember(x,x(ist,:),'rows') is a vector with 1 where the rows of x are equal to x(ist,:)
        indexplusone=indexplusone+1;
    end
end
fixedwheremissingsubj=find(fixedprofileequalityvector==0); % vector that shows the subjects where we have missing x's
profileequalityvector=fixedprofileequalityvector;

if (missingx) % generate missing x values
    for jt=1:size(x,2)
        if sum(wheremissingx(:,jt))>0
            x(wheremissingx(:,jt),jt)=round(mean(x(~wheremissingx(:,jt),jt)));
        end
    end
end

clusteralloc=unidrnd(maxnumberofclusters,sizey,1);
for ic=1:maxnumberofclusters
    indyincluster{ic}=clusteralloc==ic; % vector with ones for y in cluster ic
    Nosubjectsincluster(1,ic)=sum(indyincluster{ic});
    Noyonesincluster(1,ic)=sum(y(indyincluster{ic}));
end

alphaforpsi=0.5; % for the stick breaking prior 

for ic=1:maxnumberofclusters % phi values for the different clusters. Note: not sampling from the prior
    for j=1:numberofx
        if indicateordinal(j)==0 % if X is NOT ordinal
            betaphi{j}=ones(1,nuoflevels(j)); %prior for phiclusterj
            for ilevel=1:nuoflevels(j)
                ncjx{ic,j}(ilevel)=sum(x(clusteralloc==ic,j)==ilevel-1);
            end
            phi{ic,j}=genphi(ncjx{ic,j},betaphi{j});
        else % if X is ordinal. Here ncjx{ic,j} is the cumulative percentage of the observations
            ncjx{ic,j}(1)=0.00000000001; ncjx{ic,j}(nuoflevels(j)+1)=0.99999999999; tempsum=0;
            for ilevel=2:nuoflevels(j)
                tempsum=tempsum+sum(x(clusteralloc==ic,j)==(ilevel-2));
                ncjx{ic,j}(ilevel)=tempsum/sum(clusteralloc==ic);
                if ncjx{ic,j}(ilevel)<=ncjx{ic,j}(ilevel-1)
                    ncjx{ic,j}(ilevel)=ncjx{ic,j}(ilevel)+0.0001;
                end
                if isnan(ncjx{ic,j}(ilevel))==1
                    ncjx{ic,j}(ilevel)=ncjx{ic,j}(ilevel-1)+((1-ncjx{ic,j}(ilevel-1))/nuoflevels(j));
                end
            end
            if ncjx{ic,j}(nuoflevels(j))>=0.99999999999
                    ncjx{ic,j}(ilevel)=ncjx{ic,j}(ilevel)-0.0001;
            end
            gammathres{ic,j}=norminv(ncjx{ic,j},0,1); 
            phi{ic,j}=normcdf(gammathres{ic,j}(2:nuoflevels(j)+1),0,1)-normcdf(gammathres{ic,j}(1:nuoflevels(j)),0,1);
        end
    end
end
for j=1:numberofx % phi values for no clusters. Note: not sampling from the prior. Simplified
                  % Not relevant without variable selection
        betaphi{j}=ones(1,nuoflevels(j)); %prior for phiclusterj
        for ilevel=1:nuoflevels(j)
            ncjx{maxnumberofclusters+1,j}(ilevel)=sum(x(:,j)==ilevel-1);
        end
        phi{maxnumberofclusters+1,j}=genphi(ncjx{maxnumberofclusters+1,j},betaphi{j});
end

if (missingx) % generate missing x values
    x=genmissingx(x,wheremissingx,clusteralloc,phi); % generate missing x values
    % 
    profileequalityvector=fixedprofileequalityvector; % generate profileequalityvector
    wheremissingsubj=fixedwheremissingsubj;
    while sum(profileequalityvector==0)>0
        tempvector=ismember([y x wconf],[y(wheremissingsubj(1,1),1) x(wheremissingsubj(1,1),:) wconf(wheremissingsubj(1,1),:)],'rows');
        if sum(profileequalityvector(tempvector))>0
            profileequalityvector(tempvector)=max(profileequalityvector(tempvector));
            wheremissingsubj=find(profileequalityvector==0);
        else
            profileequalityvector(tempvector)=max(profileequalityvector)+1; 
            wheremissingsubj=find(profileequalityvector==0);
        end
    end
end

thetarisk=genthetaparamlogistic(y,wconf,betaconf,clusteralloc,maxnumberofclusters,zeros(1,maxnumberofclusters));
betaconf=genbetaconflogistic(y,wconf,thetarisk,clusteralloc,betaconf);

% *******************************************************************
% main sampling loop
% *******************************************************************
for i=2:(burnin+thin*iter)
    i
    % update the cluster parameters (psi's)
    %  psic=genpsi(Nosubjectsincluster,alphapsi);% old update with dirichlet pr
    vforpsi=genvforpsi(Nosubjectsincluster,alphaforpsi);
    psic=vforpsi;
    tempforpsi=ones(1,maxnumberofclusters)-vforpsi;
    for ipsi=2:maxnumberofclusters-1
        psic(ipsi)=psic(ipsi)*prod(tempforpsi(1,1:ipsi-1));
    end
    psic(maxnumberofclusters)=prod(tempforpsi(1,1:maxnumberofclusters-1));
    
    %update the cluster parameters (phi's)
    for ic=1:maxnumberofclusters % phi values for the different clusters.
    for j=1:numberofx
        
        if indicateordinal(j)==0 % if X is NOT ordinal
            betaphi{j}=ones(1,nuoflevels(j)); %prior for phiclusterj
            for ilevel=1:nuoflevels(j)
                ncjx{ic,j}(ilevel)=sum(x(clusteralloc==ic,j)==ilevel-1);
            end
            phi{ic,j}=genphi(ncjx{ic,j},betaphi{j});
        else % if X is ordinal
            sigmasqforgamma=0.5; sigmaforgamma=sqrt(sigmasqforgamma); % ***METROPOLIS SAMPLING for the gamma thresholds . COWLES(1996) ***** 
            gammathresnew=[gammathres{ic,j}(1) zeros(1,nuoflevels(j)-1) gammathres{ic,j}(nuoflevels(j)+1)];
            for ilevel=2:nuoflevels(j)  
                gammathresnew(ilevel)=rand_nort(gammathres{ic,j}(ilevel),sigmasqforgamma,...
                    gammathresnew(ilevel-1),gammathres{ic,j}(ilevel+1));
            end
            acc_prob=1; 
            for ilevel=2:nuoflevels(j)  
                acc_prob=acc_prob*((normcdf((gammathres{ic,j}(ilevel+1)-gammathres{ic,j}(ilevel))/sigmaforgamma)...
                    -normcdf((gammathresnew(ilevel-1)-gammathres{ic,j}(ilevel))/sigmaforgamma))/...
                    (normcdf((gammathresnew(ilevel+1)-gammathresnew(ilevel))/sigmaforgamma)...
                    -normcdf((gammathres{ic,j}(ilevel-1)-gammathresnew(ilevel))/sigmaforgamma)))*...
                    ((normcdf(gammathresnew(ilevel))-normcdf(gammathresnew(ilevel-1)))/...
                    (normcdf(gammathres{ic,j}(ilevel))-normcdf(gammathres{ic,j}(ilevel-1))))...
                    ^(sum(x(clusteralloc==ic,j)==ilevel-2));
            end
            acc_prob=acc_prob*((normcdf(gammathresnew(nuoflevels(j)+1))-normcdf(gammathresnew(nuoflevels(j))))/...
                    (normcdf(gammathres{ic,j}(nuoflevels(j)+1))-normcdf(gammathres{ic,j}(nuoflevels(j)))))...
                    ^(sum(x(clusteralloc==ic,j)==nuoflevels(j)-1)); % for the last level of Xj
            if rand<min(1,acc_prob)
               gammathres{ic,j}=gammathresnew;
               acc_prob_counter=acc_prob_counter+1;
            end    
            phi{ic,j}=normcdf(gammathres{ic,j}(2:nuoflevels(j)+1),0,1)-normcdf(gammathres{ic,j}(1:nuoflevels(j)),0,1);
        end
        
    end
    end
    for j=1:numberofx % phi values for no clusters. Simplified 
                      % Not relevant without variable selection 
                betaphi{j}=ones(1,nuoflevels(j)); %prior for phiclusterj
                phi{maxnumberofclusters+1,j}=genphi(zeros(1,nuoflevels(j)),betaphi{j}); 
    end
    % end of updating the phi's
    
    % update cluster allocations and generate vector with num of subjects
    % per cluster and vector with number of ones in each cluster
    [clusteralloc,Nosubjectsincluster,Noyonesincluster]...
        =genclusterallocswitcheslogistic(switches,y,x,wconf,psic,phi,clusteralloc,Nosubjectsincluster,Noyonesincluster,thetarisk,betaconf,profileequalityvector);
    
    if (missingx) % generate missing x values
        x=genmissingx(x,wheremissingx,clusteralloc,phi); 
        % 
        profileequalityvector=fixedprofileequalityvector; % generate profileequalityvector
        wheremissingsubj=fixedwheremissingsubj;
        while sum(profileequalityvector==0)>0
            tempvector=ismember([y x wconf],[y(wheremissingsubj(1,1),1) x(wheremissingsubj(1,1),:) wconf(wheremissingsubj(1,1),:)],'rows');
            if sum(profileequalityvector(tempvector))>0
                profileequalityvector(tempvector)=max(profileequalityvector(tempvector));
                wheremissingsubj=find(profileequalityvector==0);
            else
                profileequalityvector(tempvector)=max(profileequalityvector)+1; 
                wheremissingsubj=find(profileequalityvector==0);
            end
        end
    end
    
    % generate the theta parameters
    % for no constraint in the risk effects and no constant
    thetarisk=genthetaparamlogistic(y,wconf,betaconf,clusteralloc,maxnumberofclusters,thetarisk);
    
    % generate the coefficients for the confounders
    betaconf=genbetaconflogistic(y,wconf,thetarisk,clusteralloc,betaconf);
   
    % generate the switch parameters
    switches=ones(1,numberofx); % FOR NO SWITCHES REALLY
    
    % generate the alphaforpsi parameter
    alphaforpsi=genalphaforpsi(vforpsi,leftbound,rightbound);
    
     if i>burnin && mod(i-burnin,thin)==0
         psicsave((i-burnin)/thin,:)=psic;
         clusterallocsave((i-burnin)/thin,:)=clusteralloc;
         for ic=1:maxnumberofclusters
             ind=clusteralloc==ic;
             clustermatrixsave(ind,ind)=clustermatrixsave(ind,ind)+1;
             for j=1:numberofx
                 if switches(1,j)==1 % select the common phi for switch zero
                    phisave{(i-burnin)/thin,ic,j}=phi{ic,j};
                 else
                     phisave{(i-burnin)/thin,ic,j}=phi{maxnumberofclusters+1,j};
                 end
             end
         end
         riskthetasave((i-burnin)/thin,:)=thetarisk;
         switchessave((i-burnin)/thin,:)=switches;
         alphaforpsisave((i-burnin)/thin,1)=alphaforpsi;
         betaconfsave((i-burnin)/thin,:)=betaconf;
     end
    
end

disp(acc_prob_counter/((thin*iter+burnin)*(maxnumberofclusters+1)*sum(indicateordinal)));

clustermatrixsave=clustermatrixsave/iter;

% ***************************************************************
% selecting a clustering (least squares method)
% ***************************************************************
clusterselect=zeros(sizey,sizey);
for ic=1:maxnumberofclusters % first selected clustering
    ind=clusterallocsave(1,:)==ic;
    clusterselect(ind,ind)=clusterselect(ind,ind)+1;
end
clusterallocselectind=1;
for i=2:iter %loop for selecting a certain cluster
    clusterpossible=zeros(sizey,sizey);
    for ic=1:maxnumberofclusters 
        ind=clusterallocsave(i,:)==ic;
        clusterpossible(ind,ind)=clusterpossible(ind,ind)+1;
    end
    if sum(sum((clusterpossible-clustermatrixsave).^2))<sum(sum((clusterselect-clustermatrixsave).^2))
        clusterselect=clusterpossible; clusterallocselectind=i;
    end
end